
import argparse
from helper import load_image, save_image_file, inverse_normalize
import clip
import open_clip
import math
import torch
from sklearn.decomposition import TruncatedSVD

def plot_loss(loss_arr):
    plt.rcParams.update({'font.size': 12.5})
    fig = plt.figure(figsize=(8,5))
    plt.plot(range(0, len(loss_arr)), loss_arr)
    plt.xlabel('steps')
    plt.ylabel('loss')
    # plt.savefig('./res/original_lo.pdf')
    plt.show()

def plot_pixel_diff_csim():

    plt.rcParams.update({'font.size': 12.5})

    fig = plt.figure(figsize=(8,5))
    ax1 = fig.add_subplot(111)

    ax1.set_xlabel('steps')
    ax1.set_ylabel('cosine similarity')
    line1 = ax1.plot(range(0, len(csim_arr)), csim_arr, label = 'cosine_similarity')
    ax2 = ax1.twinx()  # instantiate a second axes that shares the same x-axis
    ax2.set_ylabel('average pixel differance')  # we already handled the x-label with ax1
    line2 = ax2.plot(range(0, len(l1_dist_arr)), np.array(l1_dist_arr)/(3*224*224), '-g', label = 'avg_diff')
    lines = line1+line2
    labs = [l.get_label() for l in lines]
    ax1.legend(lines, labs, loc='lower right', prop={'size': 12})

    plt.savefig('./res/original.pdf')
    plt.show()








