clc
close all
clear

I = single(imread('I04_noisy.png'));
sigma_a = 0.6;
l = 1;
I_o = double(imread('I04.png'));
h = fspecial('gaussian', 3, sigma_a);
N = 8;

%------------  noise variance calculation ----------------------
noise = I_o-I;
noise_f = imfilter(noise,h,'symmetric');
sigma_w = std(noise_f(:)); %Variance of noise at l=1
sigma_n = std(noise(:)); %Variance of noise at l=0
%----------------Proposed Framework------------------
tic;
d = 2^l;

I = padarray(I, ceil(size(I)/N)*N-size(I),'post','symmetric');

I_h = imfilter(I,h,'symmetric');
A1 = I_h(1:d:end,1:d:end);

[~, A1_f] = BM3D(1, double(A1), double(sigma_w));A1_f = A1_f*255;

%*********** Proposed LF denoiser ****************
I_F = LFdenoiser(A1_f, I_h, I, sigma_w);

el = toc;
disp(['elapsed time of proposed is ' num2str(el,'%2.3f') ' seconds'])
%---------------BM3D all pass-------------------------
tic;
[~, y_bm3d] = BM3D(1, double(I), double(sigma_n));
el = toc;
disp(['elapsed time of all-pass is ' num2str(el,'%2.3f') ' seconds'])

%----------------------------------------

figure('units','normalized','outerposition',[0 0 1 1])
subplot(2,2,1);
imshow(I/255);title('Noisy (spatially correlated)')
subplot(2,2,2);
imshow(y_bm3d);title('Denoised by BM3D (all-pass)')
subplot(2,2,[3 4]);
imshow(I_F/255);title('Denoised by Proposed, BM3D (high-pass)')

