function P = scheme2( N, h, g, Pc, Pn, QoS_ir, QoS_ri)
%% block coordinate descent method
% Read this program together with the journal paper in IEEE Communications Letters
% Z. Wen, S. Wang, C. Fan, and W. Xiang, Joint transceiver and power splitter design over two-way relaying channel with lattice codes and energy harvesting, IEEE Commun. Lett., vol. 18, no. 11, pp. 2039-2042, Nov. 2014.
% This method iteratively updates transmitter and receiver.

eta=0.7;
gamma=0.*ones(2,1); % \gamma_i is defined in (13); initial value of gammai can also be set to 0.5 according to Algorithm 1
w=ones(N,1); % ``w'' is the variable ``g'' in Commun. Lett.
w=w./norm(w); % initial receiver
h_gain=zeros(2,1); % uplink channel gain defined at the beginning of Section III-B
g_gain=zeros(2,1); % downlink channel gain defined at the beginning of Section III-C
A=zeros(N,N,2); % A defined in (17)
B=zeros(N,N,2); % B defined in (22)
a=zeros(2,1); % a(i) defined in (17)
iter_max=5; % iteration number

%% Start the iterative algorithm (Algorithm 1 in Commn. Lett.)
for iter =1:iter_max
    
       
    %% Update transmit beamformer f
    for i=1:2
       h_gain(i)=norm(w'*h(:,:,i))^2; % uplink channel gain defined at the beginning of Section III-B
       A(:,:,i)=g(:,:,i)*g(:,:,i)'; % A defined in (17)
       a(i)=Pn*(QoS_ir(i)-gamma(i))./(eta*h_gain(i))+Pn*(QoS_ri(i)-1)+2*Pc./eta; % a(i) defined in (17)
    end
    
    % Solve problem (18): we let F=Pr*f*f' instead of the procedure under (17)
    cvx_begin sdp quiet
    cvx_precision best

    variable F(N,N) hermitian
    
    minimize real(trace(F));
    subject to
    
    for i=1:2
    real(trace(A(:,:,i)*F))>=a(i); % constraint (18)
    end
    F>=0; % positive semidefinit constraint
    
    cvx_end
    
    [U S V]=svd(F); % SVD decomposition of F
    f=U(:,1); % obtain the optimal f for subproblem 1
    
   
    %% Update receive beamformer w
    rhoi=zeros(2,1); % \rho_i defined in (20)
    mui=zeros(2,1); % \mu_i defined in (20)
    for i=1:2
        B(:,:,i)=h(:,:,i)*h(:,:,i)'; % B defined in (22)
        g_gain(i)=norm(g(:,:,i)'*f)^2; % downlink channel gain defined at the beginning of Section III-C
        rhoi(i)=Pn*QoS_ir(i)./(eta*g_gain(i)); % \rho_i defined in (20)
        mui(i)=(Pn*(QoS_ri(i)-1)+2*Pc./eta)./g_gain(i); % \mu_i defined in (20)
    end
    
    % Solve problem (19): G=w*w'
    cvx_begin sdp quiet
    variable G(N,N) hermitian
    variable pr
    variable p1
    variable p2
    minimize real(pr+p1+p2)
    
    subject to
    for i=1:2
    pr>=rhoi(i).*real(pow_p(trace(B(:,:,i)*G),-1))+mui(i); % relay power
    end  
    p1>=real(Pn*QoS_ir(1)*pow_p(trace(B(:,:,1)*G),-1)); % 1st user's power
    p2>=real(Pn*QoS_ir(2)*pow_p(trace(B(:,:,2)*G),-1)); % 2nd user's power
    pr>=0;
    real(trace(G))==1; % norm constraint
    G==hermitian_semidefinite(N); % positive semidefinite constraint
    
    cvx_end
    
    [U S V]=svd(G); % SVD decomposition of G
    w=U(:,1); % obtain the optimal w for subproblem 2
    
end

P= real(pr+Pn*QoS_ir(1)*trace_inv(trace(B(:,:,1)*G))+Pn*QoS_ir(2)*trace_inv(trace(B(:,:,2)*G)));


end

