% check_WakemanHensonDynFCResults
dirname = 'D:\WakemanHensonDynFCResults';
filepattern = 'SSALS_EEG_125Hz_subj%02d_from%d_to%dms_iter%d_K5fold_fstd1.mat';

Niter = 40;
N = 2052; % number of source dipoles
P = 5;

subject_ID = [1 2 3 4 5 7 8 9 10 11 13 15 16];

for iid = 1:3
    NG = length(subject_ID);
    Ae_Group = zeros(N,N,P,NG);
    xe_Group = cell(1,NG);

    if (iid == 1)
        tleft = 96;
        tright = 200;
    elseif (iid == 2)
        tleft = 146;
        tright = 250;
    elseif (iid == 3)
        tleft = 196;
        tright = 300;
    end
    
    i = 0;
    for sid = subject_ID
        filename = sprintf(filepattern, sid, tleft, tright, Niter);
        disp(filename);
        filename = fullfile(dirname, filename);
        if exist(filename,'file')
            load(filename,'xe','Ae','Fs','tmswin');
        else
            warning('File does not exist!');
            continue;
        end
        
        N_Ae = size(Ae,1);
        if (N == N_Ae)
            i = i + 1;
            Ae_Group(:,:,:,i) = Ae;
            xe_Group{i} = xe;
        else
            fprintf('Does not match the number of dipoles: %d~=%d\n', N, N_Ae);
            warning('Ignoring this subject!');
        end
%     flag = (tmswin>tleft/1000 & tmswin <= tright/1000);
%     tsec = 1000*tmswin(flag);
%     sol_avg = mean(xe_Group{1},3);
%     [~,ind] = max(max(abs(sol_avg)));
%     tsec(ind)
%     figure; plot(tsec, sol_avg);
%     load('D:\WakemanHensonDynFCResults\subj01_eeg_125Hz.mat');
%     figure;
%     patch('Faces', cortex.tri, 'Vertices', cortex.pnt, 'FaceVertexCData', sol_avg(:,ind), ...
%         'EdgeColor', 'none', 'FaceColor', 'interp');
%     rotate3d on; axis off; set(gcf,'Color',[1 1 1]); axis image;
%     title(sprintf('%d ms',round(tsec(ind)))); set(gca, 'FontSize', 16);
%     
%     lighting gouraud; 
%     AZ=205.3241; EL=-14.8168; view(AZ,EL); lightangle(gca,AZ,EL);
%     hc = colorbar;
%     rect = get(hc, 'Position');
%     rect([2 4]) = rect([2 4]) + 0.1*[1 -2];
%     set(hc, 'Position', rect);
%     AZ=45.5580; EL=-21.0743; view(AZ,EL); lightangle(gca,AZ,EL);
    end
    NG = i;
    Ae_Group = Ae_Group(:,:,:,1:NG);
    xe_Group = xe_Group(1:NG);
    
    %% plot results
    A_mean = mean(Ae_Group,4);
    tstat = sqrt(NG)*A_mean./std(Ae_Group,0,4);
    pval = 2*(1-tcdf(abs(tstat),NG-1));
    pval = reshape(pval,N,[]);
    A = reshape(A_mean,N,[]);
    subplot(3,1,iid);
    hold on;
    Mask=(pval<1e-4 & pval>=1e-5 & A>0); spy(Mask,'.r',6);
    Mask=(pval<1e-4 & pval>=1e-5 & A<0); spy(Mask,'.b',6);
    Mask=(pval<1e-5 & pval>=1e-6 & A>0); spy(Mask,'.r',12);
    Mask=(pval<1e-5 & pval>=1e-6 & A<0); spy(Mask,'.b',12);
    Mask=(pval<1e-6 & A>0); spy(Mask,'.r',18);
    Mask=(pval<1e-6 & A<0); spy(Mask,'.b',18);
    for it = 1:P-1
        plot((it*N+0.5)*[1 1], [0 N]+0.5, '-k', 'LineWidth', 2);
    end
    box on;
    set(gca, 'XTick', [], 'YTick', [], 'LineWidth', 2, 'FontSize', 16);
    hold off;
    axis([0 size(A,2)+1 0 size(A,1)+1]);
    if (iid == 1)
        title(sprintf('Dynamic FC from %d to %d ms, NG=%d subjects', tleft, tright, NG));
    else
        title(sprintf('From %d to %d ms, NG=%d subjects', tleft, tright, NG));
    end
    
    drawnow;
end