function invsol_eeg_SSALS(Niter, Fs, subj_ID, interval_ID, lmbd, l2a)

load(sprintf('subj%02d_eeg_%dHz.mat', subj_ID, Fs), 'yeeg', 'tmswin', 'Kneeg');

if (interval_ID == 1)
    tleft = 96;
    tright = 200;
elseif (interval_ID == 2)
    tleft = 146;
    tright = 250;
elseif (interval_ID == 3)
    tleft = 196;
    tright = 300;
end

filename = sprintf('SSALS_EEG_%dHz_subj%02d_from%d_to%dms_iter%d_lmbd%.3f_l2a%.7f.mat', Fs, subj_ID, tleft, tright, Niter, lmbd, l2a) %#ok<NOPRT>

flag = (tmswin>tleft/1000 & tmswin <= tright/1000);
y = yeeg(flag,:,:);
Be = Kneeg;
clear yeeg Kneeg

[M,N] = size(Be); %#ok<ASGLU>
P = 5;

%%
% First dimention is time, so this is to estimate the L2-norm across time
scaleFactor = sqrt(sum(y.^2));
scaleFactor = median(scaleFactor(:)) %#ok<NOPRT>
y = y/scaleFactor;
Be = Be/scaleFactor;

% y = y/norm(reshape(y,size(y,1),[]));
% Be = Be/norm(Be);

y = permute(y,[2 1 3]);
T = size(y,2);
Nepoch = size(y,3); %#ok<NASGU>

Be = Be./sqrt(sum(Be.^2)); % standardization

%% Estimation

% Ae = A;
Ae = zeros(N,N,P);

ce = 0;

loss = ones(1,T);
% indsel = P + randsample(T-P,5);
% loss(indsel)=0;

tol = 1e-7;
[xe2, Ae2, ce2, iter] = SSALS_MCOLS(y, Be, Ae, ce, lmbd, l2a, Niter, loss, tol, true, false);


save(filename, 'xe2', 'Ae2', 'ce2', 'iter', 'lmbd', 'l2a');
