#!/bin/bash

##### CALL the function in this way to specify the parameters:
##### 
##### sbatch --export=Niter=100,Fs=125,subj_ID=1,interval_ID=1,lmbd=0.5,l2a=0.0001 run_invsol_SSALS.sh

#SBATCH --job-name=SSALS
#SBATCH --time=12:00:00
#SBATCH -N 1
#SBATCH -n 20
#SBATCH -p k2-medpri
#SBATCH --mem=40G

module load matlab/R2022a

matlab -nosplash -nodisplay -r "invsol_eeg_SSALS($Niter, $Fs, $subj_ID, $interval_ID, $lmbd, $l2a); exit;"
