"""
设置随机数种子，以便在训练深度学习模型时实现可复现性。
在深度学习中，由于存在许多随机性，例如权重初始化、数据加载、优化算法等，
设置随机数种子可以使实验结果更加可控，方便调试和比较不同模型的性能。
"""

import math
import os
import random

import numpy as np
import torch

def setup_seed(seed, cuda_deterministic=True):

    torch.manual_seed(seed)

    torch.cuda.manual_seed_all(seed)

    np.random.seed(seed)

    random.seed(seed)

    os.environ["PYTHONHASHSEED"] = str(seed)

    if cuda_deterministic:  # slower, more reproducible
        torch.backends.cudnn.deterministic = True
        torch.backends.cudnn.benchmark = False
    

    else:  # faster, less reproducible
        torch.backends.cudnn.deterministic = False
        torch.backends.cudnn.benchmark = True
